/* AppController */

#import <Cocoa/Cocoa.h>
#import <WiiRemote/WiiRemote.h>
#import <WiiRemote/WiiRemoteDiscovery.h>
#import "AsyncSocket.h"
#import "WiiFlashPacket.h"

static char table[] = {
	0x02,
	0x03,
	0x00,
	0x01,
	0x05,
	0x06,
	0x04,
	0x07,
	0x08,
	0x0a,
	0x09
};

@interface AppController : NSObject
{
	NSString	*statusMessage;

	bool	buttonAPressed;
	bool	buttonBPressed;
	bool	button1Pressed;
	bool	button2Pressed;
	bool	buttonPlusPressed;
	bool	buttonMinusPressed;
	bool	buttonHomePressed;
	bool	buttonUpPressed;
	bool	buttonDownPressed;
	bool	buttonRightPressed;
	bool	buttonLeftPressed;
	
	float	accelerationX;
	float	accelerationY;
	float	accelerationZ;

	AsyncSocket			*socket;
	WiiRemoteDiscovery	*discovery;
	WiiRemote			*wii;
	NSTimer				*timer;
	WiiFlashPacket		*packet;
	bool				isWriting;
}
- (IBAction)startServer:(id)sender;
- (IBAction)startDiscovery:(id)sender;

@end
